#!/usr/bin/perl

# This script will lift coordinates (bed format) from the D sechellia genome to D. melanogaster (dm3) genome coordinates.
# Invoke with perl sec_lift.pl file1.bed file2.bed ...
# NOTE: FILENAMES must end in bed.

use strict;
use FileHandle;

my @secfiles = @ARGV;

foreach (@secfiles) {
	my $secreads = $_;
	my $seclifted1 = $_; $seclifted1 =~ s/.bed/_lift1.bed/i;
	my $secnotlifted1 = $_; $secnotlifted1=~ s/.bed/_lift1.nomap/i;
	my $seclifted2 = $_; $seclifted2 =~ s/.bed/_lift2.bed/i;
	my $secnotlifted2 = $_; $secnotlifted2=~ s/.bed/_lift2.nomap/i;
	my $seclifted3 = $_; $seclifted3 =~ s/.bed/_lift3.bed/i;
	my $secnotlifted3 = $_; $secnotlifted3=~ s/.bed/_ext_input.bed/i;
	my $secnotlifted4 = $_; $secnotlifted4 =~ s/.bed/_lift4.nomap/i;
	my $seclifted4 = $_; $seclifted4 =~ s/.bed/_lifted.bed/i;
	printf("\nSaw this -- $secreads\n will create these \n\t$seclifted1\t$secnotlifted1\t$seclifted2\t$secnotlifted2\t$seclifted3\t$secnotlifted3\t$seclifted4\t$secnotlifted4\n");
system "liftOver -minMatch=0.75 $secreads Sec_plus_to_Secref.chain $seclifted1 $secnotlifted1";
system "liftOver -minMatch=0.75 $seclifted1 droSec1ToDm3.over.chain $seclifted2 $secnotlifted2";
system "grep -v "."\"^#\""." $secnotlifted2 > $secnotlifted3"; # cleans up unliftable files.
system "liftOver -minMatch=0.75 $secnotlifted3 Sec_rsq_extra_To_dm3.over.chain $seclifted3 $secnotlifted4";
system "cat $seclifted2 $seclifted3 > $seclifted4";
system "rm $seclifted1"; system "rm $seclifted2"; system "rm $seclifted3"; 
system "rm $secnotlifted1"; system "rm $secnotlifted2"; system "rm $secnotlifted3"; system "rm $secnotlifted4";
}
print "Lifted sechellia files over to Melanogaster space\n";
system 'date';
